#例8.30
import numpy as np

np.random.seed(10)

arr = np.random.randint(10, 31, (3, 5))  #创建一个值介于10~31之间的3*5的二维随机数组
print('原始数组：\n', arr)

arr1 = arr.copy()  #复制一个数组
print('\n使用 NumPy 对象的 sort()方法实现排序')
print('*' * 50)
print('arr1原始数组：\n', arr1)
arr1.sort()  #使用数组对象的方法排序，是原地排序，会修改原数组内容，不指定axis参数，按横轴排序
print('排序后原数组将被修改：\n', arr1)

print('\n使用sort()函数实现排序')
print('*' * 50)
print('不指定axis参数，则按横向排序，排序结果：\n', np.sort(arr))
print('指定axis参数为0，则按纵向排序，排序结果：\n', np.sort(arr, axis = 0))
print('指定axis参数为1，则按横向排序，排序结果：\n', np.sort(arr, axis = 1))
print('指定axis参数为None，则按展平后排序，排序结果：\n', np.sort(arr, axis = None))

print('\n使用argsort()函数获得排序后的元素在原数组中的索引')
print('*' * 50)
print('原始数组：\n', arr)

sort_index = np.argsort(arr)
print('排序后的元素在原数组中的索引：\n', sort_index)
print('获取排序后第一行数据：\n', arr[0,sort_index[0]])
