'''
假设某超市有一张销售表记录了某年12个月的日用品、服装、家用电器、化妆品、食品这5类的销量，假设销量的数值范围在30~90。
要求：利用NumPy数组完成以下操作。
1）使用随机数模拟该销售表，并存储在数组中。
2）查询6月份服装的销量。
3）查询1月、2月、5月、7月这4个月的服装、家用电器和化妆品的销量。
4）查询大于或等于80的销量和相应的月份。
5）按各种销售类别的销量排序。
6）按每月的销量排序。
7）计算每类销售产品的平均销量、最高销量和最低销量。
8）计算每个月的最高销量和最低销量。
9）查询最低销量及相应的销售月份和对应的产品。
10）查询最高销量及相应的销售月份和对应的产品。
'''

import numpy as np

np.random.seed(60)
#使用随机数模拟该销售表，并存储在数组中
sale = np.random.randint(30, 91, size = (12, 5))
#查询6月份服装的销量
print('6月份服装的销量：\n', sale[5, 2])
#查询1月、2月、5月、7月这4个月的服装、家用电器和化妆品的销量
print('1月、2月、5月、7月这4个月的服装、家用电器和化妆品的销量：\n', sale[[0, 1, 4, 6], 1:4])
#查询大于或等于80的销量和相应的月份
print('大于或等于80的销量：\n', sale[sale >= 80])
index_rc = np.where(sale >= 80)
r = index_rc[0]
c = index_rc[1]

print('销量大于或等于80的月份：')
for index in zip(r, c):
    data = sale[index]
    print('索引={}，值={}'.format(index, data))
#按各种销售类别的销量排序
print('按各种销售类别的销量排序：\n', np.sort(sale, axis = 0))
#按每月的销量排序
print('按每月的销量排序：\n', np.sort(sale, axis = 1))
#计算每类销售产品的平均销量、最高销量和最低销量
sale_avg = np.mean(sale, axis = 0)
sale_max = np.max(sale, axis = 0)
sale_min = np.min(sale, axis = 0)
print('每类销售产品的平均销量为：', sale_avg)
print('每类销售产品的最高销量为：', sale_max)
print('每类销售产品的最低销量为：', sale_min)
#计算每个月的最高销量和最低销量
sale_max = np.max(sale, axis = 1)
sale_min = np.min(sale, axis = 1)
print('每个月的最高销量为：', sale_max)
print('每个月的最低销量为：', sale_min)
#查询最低销量及相应的销售月份和对应的产品
sale_min = np.min(sale)
index = np.where(sale == sale_min)
print('最低销量：{}，销售月份：{}，产品：{}'.format(sale_min, index[0], index[1]))
#查询最高销量及相应的销售月份和对应的产品
sale_max = np.max(sale)
index = np.where(sale == sale_max)
print('最高销量：{}，销售月份：{}，产品：{}'.format(sale_max, index[0], index[1]))
