#例9.14
import pandas as pd
import numpy as np

data = np.random.randint(10, 50, (5, 4))
df = pd.DataFrame(data, index=[100, 29, 234, 1, 150], columns=['D', 'B', 'C', 'A'])
print('原始数据:\n', df)
print('-' * 50)

print('按index进行排序：\n', df.sort_index())
print('-' * 50)

print('按columns进行降序排序：\n', df.sort_index(axis = 1, ascending = False))
print('-' * 50)

print('按行索引为“29”的行数据进行降序排序：\n', df.sort_values(by = 29, axis = 1, ascending = False))
print('-' * 50)

print('按“A”和“B”两列数据进行升序排序：\n', df.sort_values(by = ['A', 'B'], axis = 0, ascending = True))
