import os
import csv

def count_score(score_list):
    #统计课程的最高分、最低分和平均分
    sc_max = max(score_list)
    sc_min = min(score_list)
    sc_average = round(sum(score_list) / len(score_list), 1)
    
    return sc_max, sc_min, sc_average

def data_analysis(files_dir):
    #分别读取4个文件的内容，并进行数据分析
       
    file_names = os.listdir(files_dir)  #获取file_dir路径下的所有文件名
    result = []  #定义用于保存结果的变量（列表）
    #print(file_names)
    
    for file_name in file_names:
        file_dir = os.path.join(files_dir, file_name)  #将路径和文件名拼接成文件的完整路径，用于后续的读取文件
        print(file_dir)
        
        with open(file_dir, 'r', newline = '') as file_read:  #读取文件文件内容
            csv_reader = csv.reader(file_read)  #创建读csv文件对象
            scores = next(csv_reader)   #因为文件就一行内容，所以直接用next()函数获取
        
        #print(scores)
        score_list = [eval(sc) for sc in scores]  #将读取的数据转换成整数列表
        rs = count_score(score_list)  #调用函数，进行数据统计
        result.append(rs)  #将统计结果存入列表中
        
    for i in range(len(result)):
        result[i] = list(result[i])
        result[i].insert(0, file_names[i].replace('.csv', ''))

    return result
    
def write_csv(data, file_dir, head):  #将结果存入csv文件
    with open(file_dir, 'w', newline = '') as file_write:  #打开文件
        csv_writer = csv.writer(file_write)  #创建写csv文件对象
        csv_writer.writerow(head)  #写入表头
        csv_writer.writerows(data)  #写入数据
            
if __name__ == '__main__':
    files_dir = input('请输入要分析的文件所在文件夹的路径：')  #1、确定需打开的文件所在的路径
    data = data_analysis(files_dir)
    print(data)
    file_name = input('请输入用于保存结果的文件名：')
    file_dir = os.path.join(files_dir, file_name)
    head = []
    
    for i in range(len(data[0])):  #创建表头信息
        h = input('请输入第'+ str(i+1) + '列数据的表头名称：')
        head.append(h)
    write_csv(data, file_dir, head)
    print('写入完毕！')
