import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['SimHei']

#准备初始数据
df = pd.read_csv(r'd:/code/data/学生成绩表.csv', index_col = 0, encoding = 'gbk')   #导入文件
x = df['姓名']
data = df['高等数学']

#创建画布
plt.figure()

#设置组距
bins = [50, 60, 70, 80, 90, 100]

#绘制图形
nums, bins_, hist_ = plt.hist(data, bins = bins, facecolor = 'b', alpha = 0.65)

#设置图表元素
plt.title('高等数学各分数段人数统计')
plt.xlabel('分数段')
plt.ylabel('人数')

#添加数据标签，即每个组的人数
for i, n in enumerate(nums):
    plt.text(bins[i]+5, int(n),  int(n))
 
#保存图片
plt.savefig(r'd:\code\data\成绩直方图.png')


plt.show()
