import pandas as pd
import matplotlib.pyplot as plt

plt.rcParams['font.sans-serif'] = ['Microsoft YaHei']
plt.rcParams['axes.unicode_minus'] = False

data = pd.read_excel(r'D:/code/data/1月销售统计表.xlsx')
x1 = data['杭州']
x2 = data['上海']
x3 = data['北京']
x4 = data['重庆']
x5 = data['南京']
x = [x1, x2, x3, x4, x5]
labels = ['杭州', '上海', '北京', '重庆', '南京']
plt.boxplot(x, vert = True, widths = 0.5, labels = labels, showmeans = True )
plt.title('各地区1月销售额箱形图', fontsize=20)
plt.ylabel('销售额(万元)', fontsize=15)

plt.show()

